function model = draw_cavity_hexagon(geom, model, workplane)

    format long;
    
    % Rectangular area in the unit cell where the geometry has to be specified
    rect1_x = [geom.mech.amech/4 geom.mech.amech/4 geom.mech.amech*3/4 geom.mech.amech*3/4 geom.mech.amech/4];
    rect1_y = [0 geom.mech.amech*sqrt(3)/2 geom.mech.amech*sqrt(3)/2 0 0];

    rect2_x = [geom.mech.amech*3/4 geom.mech.amech*3/4 geom.mech.amech geom.mech.amech geom.mech.amech*3/4];
    rect2_y = [-geom.mech.amech*sqrt(3)/2 geom.mech.amech*sqrt(3)/2 geom.mech.amech*sqrt(3)/2 -geom.mech.amech*sqrt(3)/2 -geom.mech.amech*sqrt(3)/2];

    % plot(rect1_x, rect1_y, 'color', 'red', 'LineWidth', 0.5)
    % plot(rect2_x, rect2_y, 'color', 'blue', 'LineWidth', 0.5)

    % Hexagon of small unit cell
    hex_x1 = [0 0 geom.mech.amech/2 geom.mech.amech geom.mech.amech geom.mech.amech/2 0];
    hex_y1 = [-geom.mech.amech/(2*sqrt(3)) geom.mech.amech/(2*sqrt(3)) geom.mech.amech/sqrt(3) geom.mech.amech/(2*sqrt(3)) -geom.mech.amech/(2*sqrt(3)) -geom.mech.amech/sqrt(3) -geom.mech.amech/(2*sqrt(3))];

    % plot(hex_x1, hex_y1, 'color', 'red', 'LineWidth', 0.5)

    % Draw snowflakes
    % angle = -60;
    x_cen = geom.mech.amech/2;
    y_cen = 0;
    [snowflake_cen_x, snowflake_cen_y] = coordinates_round_snowflake_fine(x_cen, y_cen, geom.mech.r, geom.mech.w, geom.mech.rad_curv, geom.mech.rad_curv2, geom.mech.resolution*4);

    snowflake_x4 = snowflake_cen_x + geom.mech.amech/2;
    snowflake_y4 = snowflake_cen_y + geom.mech.amech*sqrt(3)/2;

    % Coordinates of triangle where the hole sizes are scaled in order to create topological bandgap
    x_cen = geom.mech.amech;
    y_cen = geom.mech.amech/(2*sqrt(3));
    geom.mech.tri_defect_x = [x_cen-geom.mech.gap_defect_length/sqrt(3) x_cen x_cen+geom.mech.gap_defect_length/sqrt(3)];
    geom.mech.tri_defect_y = [y_cen-geom.mech.gap_defect_length/3 y_cen+geom.mech.gap_defect_length*2/3 y_cen-geom.mech.gap_defect_length/3];

    % plot(geom.mech.tri_defect_x, geom.mech.tri_defect_y, 'color', 'red', 'LineWidth', 0.5)

    % Position of optical cavity
    x_cen = geom.mech.amech/2;
    y_cen = geom.mech.amech/sqrt(3) + geom.opt.cavity_shift*geom.opt.a1/2;
    temp_x = [x_cen-geom.opt.defect_width/2 x_cen-geom.opt.defect_width/2 x_cen+geom.opt.defect_width/2 x_cen+geom.opt.defect_width/2];
    temp_y = [y_cen-geom.opt.defect_length/2 y_cen+geom.opt.defect_length/2 y_cen+geom.opt.defect_length/2 y_cen-geom.opt.defect_length/2];
    [geom.opt.defect_x, geom.opt.defect_y] = rotate(temp_x, temp_y, x_cen, y_cen, geom.opt.cavity_rot);

    % plot(geom.opt.defect_x, geom.opt.defect_y, 'color', 'red', 'LineWidth', 0.5)

    delta2 = [geom.opt.a1*ones(1,geom.opt.nv-5), ...
        (geom.opt.a1+geom.opt.a2)/2, ... %1
        geom.opt.a2, ... %2
        (geom.opt.a2+geom.opt.a3)/2, ... %3
        geom.opt.a3, ... %4
        (geom.opt.a3+geom.opt.a4)/2, ... %5
        geom.opt.a4, ... %6
        (geom.opt.a3+geom.opt.a4)/2, ... %7
        geom.opt.a3, ... %8
        (geom.opt.a2+geom.opt.a3)/2, ... %9
        geom.opt.a2, ... %10
        (geom.opt.a1+geom.opt.a2)/2, ... %11
        geom.opt.a1*ones(1,geom.opt.nv-5)];

    delta1 = [geom.opt.a1*ones(1,geom.opt.nv-6), ...
        (geom.opt.a1+(geom.opt.a1+geom.opt.a2)/2)/2, ... %1
        (geom.opt.a2+(geom.opt.a1+geom.opt.a2)/2)/2, ... %2
        (geom.opt.a2+(geom.opt.a2+geom.opt.a3)/2)/2, ... %3
        (geom.opt.a3+(geom.opt.a2+geom.opt.a3)/2)/2, ... %4
        (geom.opt.a3+(geom.opt.a3+geom.opt.a4)/2)/2, ... %5
        (geom.opt.a4+(geom.opt.a3+geom.opt.a4)/2)/2, ... %6
        (geom.opt.a4+(geom.opt.a3+geom.opt.a4)/2)/2, ... %7
        (geom.opt.a3+(geom.opt.a3+geom.opt.a4)/2)/2, ... %8
        (geom.opt.a3+(geom.opt.a2+geom.opt.a3)/2)/2, ... %9
        (geom.opt.a2+(geom.opt.a2+geom.opt.a3)/2)/2, ... %10
        (geom.opt.a2+(geom.opt.a1+geom.opt.a2)/2)/2, ... %11
        (geom.opt.a1+(geom.opt.a1+geom.opt.a2)/2)/2, ... %12
        geom.opt.a1*ones(1,geom.opt.nv-6)];
    x = zeros(2*geom.opt.nv+1, 2*geom.opt.nh+1);
    y = zeros(2*geom.opt.nv+1, 2*geom.opt.nh+1);
    rad = zeros(2*geom.opt.nv+1, 2*geom.opt.nh+1);
    radb = zeros(2*geom.opt.nv+1, 2*geom.opt.nh+1);

    for j = -geom.opt.nh:geom.opt.nh
        if j==-geom.opt.nh
            if rem(geom.opt.nv,2) == 0
                x(:,j+geom.opt.nh+1) = -geom.opt.nh*geom.opt.a1*sqrt(3)/2 - geom.opt.W/2;
            else
                x(:,j+geom.opt.nh+1) = -(geom.opt.nh+1)*geom.opt.a1*sqrt(3)/2 - geom.opt.W/2;
            end
        else
            if j==0 || j==1
                x(:,j+geom.opt.nh+1) = x(:,j+geom.opt.nh) + (geom.opt.a1*sqrt(3) + geom.opt.W)/2;
            else
                x(:,j+geom.opt.nh+1) = x(:,j+geom.opt.nh) + geom.opt.a1*sqrt(3)/2;
            end
        end

        for i=-geom.opt.nv:geom.opt.nv
            rad(i+geom.opt.nv+1,j+geom.opt.nh+1) = geom.opt.r;

            if i==-geom.opt.nv
                if rem(j,2)==0
                    y(i+geom.opt.nv+1,j+geom.opt.nh+1) = -sum(delta1(1:geom.opt.nv));
                else
                    y(i+geom.opt.nv+1,j+geom.opt.nh+1) = -sum(delta2(1:geom.opt.nv))-geom.opt.a3/2;
                end
            else
                if rem(j,2)==0
                    y(i+geom.opt.nv+1,j+geom.opt.nh+1) = y(i+geom.opt.nv,j+geom.opt.nh+1)+delta1(i+geom.opt.nv);
                else
                    y(i+geom.opt.nv+1,j+geom.opt.nh+1) = y(i+geom.opt.nv,j+geom.opt.nh+1)+delta2(i+geom.opt.nv);
                end
            end
        end
    end

    temp_x = x+x_cen;
    temp_y = y+y_cen;
    [x, y] = rotate(temp_x, temp_y, x_cen, y_cen, geom.opt.cavity_rot);

    % Constructing cavity holes in region 1 of geometry schematic
    count.a1 = 1; count.a2 = 1; count.a3 = 1; count.b1 = 1; count.b2 = 1; count.b3 = 1; 
    count.l1t = 1; count.l1b = 1; count.l1m = 1; count.l2t = 1; count.l2b = 1; count.l2m = 1;
    count.l3t = 1; count.l3b = 1; count.l3m = 1; count.l4t = 1; count.l4b = 1; count.l4m = 1;
    count.l5t = 1; count.l5b = 1; count.l5m = 1; count.l6t = 1; count.l6b = 1; count.l6m = 1;
    
    inp.a1 = []; inp.a2 = []; inp.a3 = []; inp.b1 = []; inp.b2 = []; inp.b3 = []; 
    inp.l1t = []; inp.l1b = []; inp.l1m = []; inp.l2t = []; inp.l2b = []; inp.l2m = [];
    inp.l3t = []; inp.l3b = []; inp.l3m = []; inp.l4t = []; inp.l4b = []; inp.l4m = [];
    inp.l5t = []; inp.l5b = []; inp.l5m = []; inp.l6t = []; inp.l6b = []; inp.l6m = [];
    
    for j = -geom.opt.nh:geom.opt.nh
        for i = -geom.opt.nv:geom.opt.nv
            x1 = x(i+geom.opt.nv+1,j+geom.opt.nh+1);
            y1 = y(i+geom.opt.nv+1,j+geom.opt.nh+1);

            r1 = rad(i+geom.opt.nv+1,j+geom.opt.nh+1);
            rh = geom.opt.h;
            rb = geom.opt.b;

            if inpolygon(x1, y1, geom.opt.defect_x, geom.opt.defect_y) == 0
                phi = linspace(0,2*pi,37);
                xx = x1 + r1*cos(phi)/geom.scale_small_holes;
                yy = y1 + r1*sin(phi)/geom.scale_small_holes;
            else
                y1 = y(i+geom.opt.nv+1,j+1+geom.opt.nh+1);
                phi = linspace(0,2*pi,37);
                xx = x1 + rb*cos(phi)/geom.scale_small_holes;
                yy = y1 + rh*sin(phi)/geom.scale_small_holes;
            end

            for k=1:length(xx)-1
                check(k)=abs(p_poly_dist1(xx(k),yy(k),snowflake_cen_x,snowflake_cen_y));
            end

            in_scale_tri = inpolygon(xx(1:end-1), yy(1:end-1), geom.mech.tri_defect_x, geom.mech.tri_defect_y);
            in_scale_tri2 = inpolygon(xx(1:end-1), yy(1:end-1), geom.mech.tri_defect_x-geom.mech.amech, geom.mech.tri_defect_y);
            in_defect = inpolygon(xx(1:end-1), yy(1:end-1), geom.opt.defect_x, geom.opt.defect_y);
            in_rect1 = inpolygon(xx(1:end-1), yy(1:end-1), rect1_x, rect1_y);
            in_uc = inpolygon(xx(1:end-1), yy(1:end-1), hex_x1, hex_y1);
            in = inpolygon(xx(1:end-1), yy(1:end-1), snowflake_cen_x, snowflake_cen_y);
            
            if inpolygon(x1, y1, geom.opt.defect_x, geom.opt.defect_y) == 0
                phi = linspace(0,2*pi,37);
                xx = x1 + r1*cos(phi);
                yy = y1 + r1*sin(phi);
            else
                y1 = y(i+geom.opt.nv+1,j+1+geom.opt.nh+1);
                phi = linspace(0,2*pi,37);
                xx = x1 + rb*cos(phi);
                yy = y1 + rh*sin(phi);
            end

            dist1 = x1 - geom.mech.amech/4;
            dist2 = geom.mech.amech*3/4 - x1;
            
            tag = strcat('c','x',num2str(i),'y',num2str(j));

            if min(check)>geom.bridge_width && sum(in_uc)==length(xx)-1 && sum(in_rect1)==length(xx)-1 && sum(in)==0 && sum(in_defect)==0 && dist1>geom.opt.a1*sqrt(3)/2 && dist2>geom.opt.a1*sqrt(3)/2
                if sum(in_scale_tri) == length(xx)-1 || sum(in_scale_tri2) == length(xx)-1
                    [inp, count, model] = draw_cavity_array(x1+(xx-x1)*geom.opt.scale_top_gap, y1+(yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                else
                    [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                end
                    
            elseif min(check)>geom.bridge_width && sum(in_uc)>0 && sum(in_rect1)==length(xx)-1 && sum(in)==0 && sum(in_defect)==0 && dist1>geom.opt.a1*sqrt(3)/2 && dist2>geom.opt.a1*sqrt(3)/2
                if max(xx)<geom.mech.amech/2
                    if sum(in_scale_tri) == length(xx)-1 || sum(in_scale_tri2) == length(xx)-1
                        [inp, count, model] = draw_cavity_array(x1+(xx-x1)*geom.opt.scale_top_gap, y1+(yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                    else
                        [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                    end
                    
                elseif min(xx)>geom.mech.amech/2
                    x1 = x1 - geom.mech.amech/2;
                    y1 = y1 - geom.mech.amech*sqrt(3)/2;
                    
                    xx = xx - geom.mech.amech/2;
                    yy = yy - geom.mech.amech*sqrt(3)/2;

                    if sum(in_scale_tri) == length(xx)-1 || sum(in_scale_tri2) == length(xx)-1
                        [inp, count, model] = draw_cavity_array(x1+(xx-x1)*geom.opt.scale_top_gap, y1+(yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                    else
                        [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                    end
                end
                    
            elseif min(check)>geom.bridge_width && sum(in_uc)>0 && sum(in_rect1)==length(xx)-1 && sum(in)==0 && sum(in_defect)~=0 && geom.opt.h ~=0 && geom.opt.b ~=0 && dist1>geom.opt.a1*sqrt(3)/2 && dist2>geom.opt.a1*sqrt(3)/2
                if sum(in_scale_tri) == length(xx)-1 || sum(in_scale_tri2) == length(xx)-1
                    [inp, count, model] = draw_cavity_array(x1+(xx-x1)*geom.opt.scale_top_gap, y1+(yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                else
                    [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                end
                    
            elseif min(check)>geom.bridge_width && sum(in_uc)>0 && sum(in_rect1)==length(xx)-1 && sum(in)==0 && sum(in_defect)==0 && dist2<geom.opt.a1*sqrt(3)/2
                x1 = x1 + (dist2 - geom.opt.a1*sqrt(3)/2)/2;
                xx = xx + (dist2 - geom.opt.a1*sqrt(3)/2)/2;

                if sum(in_uc)==length(xx)-1
                    if sum(in_scale_tri) == length(xx)-1 || sum(in_scale_tri2) == length(xx)-1
                        [inp, count, model] = draw_cavity_array(x1+(xx-x1)*geom.opt.scale_top_gap, y1+(yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                    else
                        [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                    end
                else
                    x1 = x1 - geom.mech.amech/2;
                    y1 = y1 - geom.mech.amech*sqrt(3)/2;
                    
                    xx = xx - geom.mech.amech/2;
                    yy = yy - geom.mech.amech*sqrt(3)/2;

                    if sum(in_scale_tri) == length(xx)-1 || sum(in_scale_tri2) == length(xx)-1
                        [inp, count, model] = draw_cavity_array(x1+(xx-x1)*geom.opt.scale_top_gap, y1+(yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                    else
                        [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                    end
                end
                    
            elseif min(check)>geom.bridge_width && sum(in_uc)>0 && sum(in_rect1)==length(xx)-1 && sum(in)==0 && sum(in_defect)==0 && dist1<geom.opt.a1*sqrt(3)/2
                x1 = x1 + (geom.opt.a1*sqrt(3)/2 - dist1)/2;
                xx = xx + (geom.opt.a1*sqrt(3)/2 - dist1)/2;

                if sum(in_scale_tri) == length(xx)-1 || sum(in_scale_tri2) == length(xx)-1
                    [inp, count, model] = draw_cavity_array(x1+(xx-x1)*geom.opt.scale_top_gap, y1+(yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                else
                    [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                end
            end
        end
    end
    
    % Constructing cavity holes in region 2 of geometry schematic
    geom.opt.defect_x = geom.opt.defect_x + geom.mech.amech/2;
    geom.opt.defect_y = geom.opt.defect_y - geom.mech.amech*sqrt(3)/2;

    for j = -geom.opt.nh:geom.opt.nh
        for i = -geom.opt.nv:geom.opt.nv
            x1 = x(i+geom.opt.nv+1,j+geom.opt.nh+1) + geom.mech.amech/2;
            y1 = y(i+geom.opt.nv+1,j+geom.opt.nh+1) - geom.mech.amech*sqrt(3)/2;

            r1 = rad(i+geom.opt.nv+1,j+geom.opt.nh+1);
            rh = geom.opt.h;
            rb = geom.opt.b;

            % Note that here y of the center holes is not exactly same as next
            % row because of cavity defect
            if inpolygon(x1, y1, geom.opt.defect_x, geom.opt.defect_y) == 0
                phi = linspace(0,2*pi,37);
                xx = x1 + r1*cos(phi)/geom.scale_small_holes;
                yy = y1 + r1*sin(phi)/geom.scale_small_holes;
            else
                y1 = y(i+geom.opt.nv+1,j+1+geom.opt.nh+1) - geom.mech.amech*sqrt(3)/2;
                phi = linspace(0,2*pi,37);
                xx = x1 + rb*cos(phi)/geom.scale_small_holes;
                yy = y1 + rh*sin(phi)/geom.scale_small_holes;
            end

            for k=1:length(xx)-1
                check(k)=abs(p_poly_dist1(xx(k),yy(k),snowflake_cen_x,snowflake_cen_y));
                check1(k)=abs(p_poly_dist1(xx(k),yy(k),snowflake_x4,snowflake_y4));
            end

            in_scale_tri = inpolygon(xx(1:end-1), yy(1:end-1), geom.mech.tri_defect_x, geom.mech.tri_defect_y);
            in_defect = inpolygon(xx(1:end-1), yy(1:end-1), geom.opt.defect_x, geom.opt.defect_y);
            in_rect2 = inpolygon(xx(1:end-1), yy(1:end-1), rect2_x, rect2_y);
            in_uc = inpolygon(xx(1:end-1), yy(1:end-1), hex_x1, hex_y1);
            in = inpolygon(xx(1:end-1), yy(1:end-1), snowflake_cen_x, snowflake_cen_y);
            in1 = inpolygon(xx(1:end-1), yy(1:end-1), snowflake_x4, snowflake_y4);
            
            if inpolygon(x1, y1, geom.opt.defect_x, geom.opt.defect_y) == 0
                phi = linspace(0,2*pi,37);
                xx = x1 + r1*cos(phi);
                yy = y1 + r1*sin(phi);
            else
                y1 = y(i+geom.opt.nv+1,j+1+geom.opt.nh+1) - geom.mech.amech*sqrt(3)/2;
                phi = linspace(0,2*pi,37);
                xx = x1 + rb*cos(phi);
                yy = y1 + rh*sin(phi);
            end

            dist = x1 - geom.mech.amech*3/4;

            if min(check)>geom.bridge_width && sum(in_uc)==length(xx)-1 && sum(in_rect2)==length(xx)-1 && sum(in)==0 && sum(in_defect)==0 && dist>geom.opt.a1*sqrt(3)/2
                if sum(in_scale_tri) == length(xx)-1
                    tag = strcat('c2','x',num2str(i),'y',num2str(j));
                    [inp, count, model] = draw_cavity_array(x1+(xx-x1)*geom.opt.scale_top_gap, y1+(yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                    
                    x1 = geom.mech.amech - x1;
                    xx = geom.mech.amech - xx;
                    tag = strcat('c2_mir_','x',num2str(i),'y',num2str(j));
                    [inp, count, model] = draw_cavity_array(x1+(xx-x1)*geom.opt.scale_top_gap, y1+(yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                    
                else
                    tag = strcat('c2','x',num2str(i),'y',num2str(j));
                    [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                    
                    x1 = geom.mech.amech - x1;
                    xx = geom.mech.amech - xx;
                    tag = strcat('c2_mir_','x',num2str(i),'y',num2str(j));
                    [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                end
                    
            elseif min(check)>geom.bridge_width && sum(in_rect2)>0 && sum(in)==0 && sum(in_uc)>0 && sum(in_defect)~=0 && geom.opt.h~=0 && geom.opt.b~=0 && dist>geom.opt.a1*sqrt(3)/2
                if sum(in_scale_tri) == length(xx)-1
%                     tag = strcat('c2','x',num2str(i),'y',num2str(j));
%                     [inp, count, model] = draw_cavity_array(x1+(xx-x1)*geom.opt.scale_top_gap, y1+(yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                    
                    x1 = geom.mech.amech - x1;
                    xx = geom.mech.amech - xx;
                    tag = strcat('c2_mir','x',num2str(i),'y',num2str(j));
                    [inp, count, model] = draw_cavity_array(x1+(xx-x1)*geom.opt.scale_top_gap, y1+(yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                else
%                     tag = strcat('c2','x',num2str(i),'y',num2str(j));
%                     [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                    
                    x1 = geom.mech.amech - x1;
                    xx = geom.mech.amech - xx;
                    tag = strcat('c2_mir','x',num2str(i),'y',num2str(j));
                    [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                end
                    
            elseif min(check)>geom.bridge_width && min(xx)<geom.mech.amech*3/4 && sum(in_uc)>0 && max(xx)>geom.mech.amech*3/4 && sum(in_rect2)>0 && sum(in)==0 && sum(in_defect)==0
                x1 = geom.mech.amech*3/4;
                if sum(in_uc)~=length(xx)-1
                    y1 = geom.mech.amech/sqrt(3) - abs((x1 - geom.mech.amech/2))/sqrt(3);
                end
                
                phi = linspace(0,2*pi,37);
                xx = x1 + r1*cos(phi);
                yy = y1 + r1*sin(phi);

                if sum(in_scale_tri) == length(xx)-1
                    if sum(in_uc)~=length(xx)-1
                        tag = strcat('c2','x',num2str(i),'y',num2str(j));
                        [inp, count, model] = draw_cavity_array(x1 - geom.mech.amech/2 + (xx-x1)*geom.opt.scale_top_gap, y1 - geom.mech.amech*sqrt(3)/2 + (yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                        
                        x1 = geom.mech.amech - x1;
                        xx = geom.mech.amech - xx;
                        tag = strcat('c2_mir','x',num2str(i),'y',num2str(j));
                        [inp, count, model] = draw_cavity_array(x1 + (xx-x1)*geom.opt.scale_top_gap, y1 + (yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                    else
                        tag = strcat('c2','x',num2str(i),'y',num2str(j));
                        [inp, count, model] = draw_cavity_array(x1 + (xx-x1)*geom.opt.scale_top_gap, y1 + (yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                        
                        x1 = geom.mech.amech - x1;
                        xx = geom.mech.amech - xx;
                        tag = strcat('c2_mir','x',num2str(i),'y',num2str(j));
                        [inp, count, model] = draw_cavity_array(x1 + (xx-x1)*geom.opt.scale_top_gap, y1 + (yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                    end
                else
                    if sum(in_uc)~=length(xx)-1
                        tag = strcat('c2','x',num2str(i),'y',num2str(j));
                        [inp, count, model] = draw_cavity_array(xx - geom.mech.amech/2, yy - geom.mech.amech*sqrt(3)/2, tag, inp, count, geom, model, workplane);
                        
                        x1 = geom.mech.amech - x1;
                        xx = geom.mech.amech - xx;
                        tag = strcat('c2_mir','x',num2str(i),'y',num2str(j));
                        [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                    else
                        tag = strcat('c2','x',num2str(i),'y',num2str(j));
                        [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                        
                        x1 = geom.mech.amech - x1;
                        xx = geom.mech.amech - xx;
                        tag = strcat('c2_mir','x',num2str(i),'y',num2str(j));
                        [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                    end
                end
                    
            elseif min(check)>geom.bridge_width && sum(in_uc)==length(xx)-1 && sum(in_rect2)==length(xx)-1 && sum(in)==0 && sum(in_defect)==0 && dist<geom.opt.a1*sqrt(3)/2
                x1 = x1 + (geom.opt.a1*sqrt(3)/2 - dist)/2;
                xx = xx + (geom.opt.a1*sqrt(3)/2 - dist)/2;

                if sum(in_scale_tri) == length(xx)-1
                    tag = strcat('c2','x',num2str(i),'y',num2str(j));
                    [inp, count, model] = draw_cavity_array(x1 + (xx-x1)*geom.opt.scale_top_gap, y1 + (yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                    
                    x1 = geom.mech.amech - x1;
                    xx = geom.mech.amech - xx;
                    tag = strcat('c2_mir_','x',num2str(i),'y',num2str(j));                    
                    [inp, count, model] = draw_cavity_array(x1 + (xx-x1)*geom.opt.scale_top_gap, y1 + (yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                else
                    tag = strcat('c2','x',num2str(i),'y',num2str(j));
                    [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                    
                    x1 = geom.mech.amech - x1;
                    xx = geom.mech.amech - xx;
                    tag = strcat('c2_mir_','x',num2str(i),'y',num2str(j));
                    [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                end
                    
            elseif min(check)>geom.bridge_width && sum(in_uc)>0 && sum(in_rect2)>0 && sum(in)==0 && sum(in1)==0 && min(xx)>geom.mech.amech*3/4 && min(yy)>0
                if sum(in_scale_tri) == length(xx)-1
                    tag = strcat('c2_mir_','x',num2str(i),'y',num2str(j));
                    [inp, count, model] = draw_cavity_array(geom.mech.amech - x1 + (xx-x1)*geom.opt.scale_top_gap, y1 + (yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                else                    
                    tag = strcat('c2_mir_','x',num2str(i),'y',num2str(j));
                    [inp, count, model] = draw_cavity_array(geom.mech.amech - xx, yy, tag, inp, count, geom, model, workplane);
                end

                x1 = x1 - geom.mech.amech/2;
                y1 = y1 - geom.mech.amech*sqrt(3)/2;
                
                xx = xx - geom.mech.amech/2;
                yy = yy - geom.mech.amech*sqrt(3)/2;

                if sum(in_scale_tri) == length(xx)-1
                    tag = strcat('c2','x',num2str(i),'y',num2str(j));
                    [inp, count, model] = draw_cavity_array(x1 + (xx-x1)*geom.opt.scale_top_gap, y1 + (yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                else
                    tag = strcat('c2','x',num2str(i),'y',num2str(j));
                    [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                end
                    
            elseif min(check1)>geom.bridge_width && sum(in_uc)==0 && sum(in_rect2)>0 && sum(in)==0 && sum(in1)==0 && min(xx)>geom.mech.amech*3/4 && min(yy)>0 && sum(in_defect)==0
                x1 = x1 - geom.mech.amech/2;
                y1 = y1 - geom.mech.amech*sqrt(3)/2;
                
                xx = xx - geom.mech.amech/2;
                yy = yy - geom.mech.amech*sqrt(3)/2;

                if sum(in_scale_tri) == length(xx)-1
                    tag = strcat('c2_','x',num2str(i),'y',num2str(j));
                    [inp, count, model] = draw_cavity_array(x1 + (xx-x1)*geom.opt.scale_top_gap, y1 + (yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                    
                    x1 = geom.mech.amech - x1;
                    xx = geom.mech.amech - xx;
                    tag = strcat('c2_mir_','x',num2str(i),'y',num2str(j));
                    [inp, count, model] = draw_cavity_array(x1 + (xx-x1)*geom.opt.scale_top_gap, y1 + (yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                else
                    tag = strcat('c2_','x',num2str(i),'y',num2str(j));
                    [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                    
                    xx = geom.mech.amech - xx;
                    tag = strcat('c2_mir_','x',num2str(i),'y',num2str(j));
                    [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                end
                    
            elseif min(check1)>geom.bridge_width && sum(in_uc)==0 && sum(in_rect2)>0 && sum(in)==0 && sum(in1)==0 && min(xx)>geom.mech.amech*3/4 && min(yy)>0 && sum(in_defect)~=0
                x1 = x1 - geom.mech.amech/2;
                y1 = y1 - geom.mech.amech*sqrt(3)/2;
                
                xx = xx - geom.mech.amech/2;
                yy = yy - geom.mech.amech*sqrt(3)/2;

                if sum(in_scale_tri) == length(xx)-1
                    tag = strcat('c2_','x',num2str(i),'y',num2str(j));
                    [inp, count, model] = draw_cavity_array(x1 + (xx-x1)*geom.opt.scale_top_gap, y1 + (yy-y1)*geom.opt.scale_top_gap, tag, inp, count, geom, model, workplane);
                else
                    tag = strcat('c2_','x',num2str(i),'y',num2str(j));
                    [inp, count, model] = draw_cavity_array(xx, yy, tag, inp, count, geom, model, workplane);
                end
            end
        end
    end
    
    uni = workplane.geom.create('uni_a', 'Union');
    uni.selection('input').set(horzcat(inp.l2t, inp.b1, inp.l1t, inp.l1b, inp.l1m, inp.a1, inp.l6t, inp.l6b, inp.l6m, inp.b3, inp.l5t));
    
    uni = workplane.geom.create('uni_b', 'Union');
    uni.selection('input').set(horzcat(inp.l2b, inp.a2, inp.l3b, inp.l3t, inp.l3m, inp.b2, inp.l4t, inp.l4b, inp.l4m, inp.a3, inp.l5b));
    
    uni = workplane.geom.create('uni_c', 'Union');
    uni.selection('input').set(horzcat(inp.l2m, inp.l5m));
    
    copy_str = {'uni_a' 'uni_b' 'uni_c'};
    array_length = [floor(geom.stack.num_domy/2)+1 floor((geom.stack.num_domy+1)/2) floor((geom.stack.num_domy+1)/2)];
    array_copy_length = [floor((geom.stack.num_domy+1)/2) floor(geom.stack.num_domy/2) floor(geom.stack.num_domy/2)];
    
    count = 1;
    for i=1:length(copy_str)
        % For creating another domain where optical cavities are in top
        % part of unit cell
        mir = workplane.geom.create(strcat('mir_', copy_str(i)), 'Mirror');
        mir.set('keep', false);
        mir.selection('input').set(copy_str(i));
        mir.set('pos', {'0' '0'});
        mir.set('axis', [0 1]);
        
        inp_all(count) = strcat('mir_', copy_str(i));
        count = count + 1;
        
        % Copy it to bottom two unit cells (from the top of strip)
        copy = workplane.geom.create(strcat('cp1_', copy_str(i)), 'Copy');
        copy.selection('input').set(strcat('mir_', copy_str(i)));
        copy.set('displx', num2str(-geom.mech.amech,'%10.9e'));
        
        inp_all(count) = strcat('cp1_', copy_str(i));
        count = count + 1;
        
        copy = workplane.geom.create(strcat('cp2_', copy_str(i)), 'Copy');
        copy.selection('input').set(strcat('mir_', copy_str(i)));
        copy.set('displx', num2str(-geom.mech.amech/2,'%10.9e'));
        copy.set('disply', num2str(geom.mech.amech*sqrt(3)/2,'%10.9e'));
        
        inp_all(count) = strcat('cp2_', copy_str(i));
        count = count + 1;
        
        copy = workplane.geom.create(strcat('cp3_', copy_str(i)), 'Copy');
        copy.selection('input').set(strcat('mir_', copy_str(i)));
        copy.set('displx', num2str(geom.mech.amech/2,'%10.9e'));
        copy.set('disply', num2str(geom.mech.amech*sqrt(3)/2,'%10.9e'));
        
        inp_all(count) = strcat('cp3_', copy_str(i));
        count = count + 1;
        
        % Array for domain 1
        for j=1:array_length(i)-1
            copy = workplane.geom.create(strcat('arr_', copy_str(i), num2str(j)), 'Copy');
            copy.selection('input').set(horzcat(strcat('mir_', copy_str(i)), strcat('cp3_', copy_str(i))));
            copy.set('displx', num2str(-3/2*geom.mech.amech*j,'%10.9e'));
            copy.set('disply', num2str(geom.mech.amech*sqrt(3)/2*j,'%10.9e'));

            inp_all(count) = strcat('arr_', copy_str(i), {num2str(j)});
            count = count + 1;
        end
        
        for j=1:array_copy_length(i)-1
            copy = workplane.geom.create(strcat('arr_cp_', copy_str(i), num2str(j)), 'Copy');
            copy.selection('input').set(horzcat(strcat('cp1_', copy_str(i)), strcat('cp2_', copy_str(i))));
            copy.set('displx', num2str(-3/2*geom.mech.amech*j,'%10.9e'));
            copy.set('disply', num2str(geom.mech.amech*sqrt(3)/2*j,'%10.9e'));

            inp_all(count) = strcat('arr_cp_', copy_str(i), {num2str(j)});
            count = count + 1;
        end
    end
    
    if rem(geom.stack.num_domy, 2)==0
        copy = workplane.geom.create('cp_wall_c', 'Copy');
        copy.selection('input').set({'mir_uni_c' 'cp3_uni_c'});
        copy.set('displx', num2str(-3/4*geom.mech.amech*geom.stack.num_domy,'%10.9e'));
        copy.set('disply', num2str(geom.stack.num_domy*geom.mech.amech*sqrt(3)/4,'%10.9e'));
        
        inp_all(count) = {'cp_wall_c'};
        count = count + 1;
    else
        copy = workplane.geom.create('cp_wall_c', 'Copy');
        copy.selection('input').set({'cp1_uni_c' 'cp2_uni_c'});
        copy.set('displx', num2str(-3/4*geom.mech.amech*(geom.stack.num_domy-1),'%10.9e'));
        copy.set('disply', num2str((geom.stack.num_domy-1)*geom.mech.amech*sqrt(3)/4,'%10.9e'));
        
        inp_all(count) = {'cp_wall_c'};
        count = count + 1;
    end
    
    uni = workplane.geom.create('uni_domain1', 'Union');
    uni.selection('input').set(horzcat(inp_all, 'uni_a', 'uni_b', 'uni_c'));
end